/*
* Copyright(C) 2008  CERTEX
*
*    ,     .
* 
*        ,
* ,    ,
*     ,
* ,      
*     
*      .
*
*
* FileVersion  : 1.1.211.227
* PrivateBuild : 1.43
* Date modify  : 02.05.08
* FileDescription : CERTEX CryptoAPI 
*
*/
#ifndef __CERTTSTRUCTURE_H__
#define __CERTTSTRUCTURE_H__

#define MAX_CHAIN_LENGTH       7

#define CRT_STORE_PROV_LDAP     0
#define CRT_STORE_PROV_MEMORY   1
#define CRT_STORE_PROV_SYSTEM   2
#define CRT_STORE_PROV_FILE     3


typedef unsigned long hCERTCLASS;
typedef unsigned long hCERTSTORE;

typedef unsigned long hPKICONTEXT;
typedef unsigned long hENROLLCONTEXT;
typedef unsigned long hCERTCONTEXT;
typedef unsigned long hCRLCONTEXT;
typedef unsigned long hCRYPTMSG;
typedef unsigned long hAUTHMSG;
typedef unsigned long hCERTCHAINCONTEXT;
typedef unsigned long hCERTCOLLECTION;


typedef struct _CERT_CRL_CHAIN {
  int             certCount;
  hCERTCONTEXT    hCertContext;
  int             crlCount;
  hCRLCONTEXT     hCRLContext;
  int             crtcrlCount;
  hCERTCONTEXT    hCertCRLContext;
  unsigned long   Flags;
} CERT_CRL_CHAIN, *pCERT_CRL_CHAIN;



typedef struct _CERT_COLLECTION {
  int             certCount;
  hCERTSTORE      hStore;
  hCERTSTORE      hMY;
  hCERTCONTEXT    hContext;
  unsigned long   Flags;
} CERT_COLLECTION, *pCERT_COLLECTION;

typedef struct _CERT_INF {
  unsigned long         Version;
  unsigned char         SerNum[64];
  long                  SerNumSize;
  char                  SignAlg[32];
  char                  Issuer[256];
  char                  NotBefore[16];
  char                  NotAfter[16];
  char                  Subject[256];
  unsigned char         PublicKey[1024];
  long                  PubKeySize;
  char                  KeyOID[32];
  unsigned char         IssSerNum[64];
  long                  IssSerNumSize;
  char                  CApoint[128];
  char                  CRLpoint[128];
  unsigned char         CertBody[4096];
  long                  certSize;
} CERT_INF, *PCERT_INF;

typedef struct _CRT_EXTENSION {
  char                  *ExtOID;
  bool                  CriticalFlg;
  unsigned char         *ExtValue;
  long                  ExtSize;
} CRT_EXTENSION, *PCRT_EXTENSION;

typedef struct _CERT_ATTRIBUTES {
  char                  *AttOID;
  bool                  AttType;
  unsigned char         *AttValue;
  long                  AttSize;
} CERT_ATTRIBUTES, *PCERT_ATTRIBUTES;

typedef struct _CRL_ENTR {
  unsigned char         **SerialNumber;
  long                  *SerNumSize;
  char                  **RevokeDate;
  int                   *RevokeReason;
  char                  **InvalidDate;
} CRL_ENTR, *PCRL_ENTR;

typedef struct _CRL_INF {
  unsigned long		    Version;
  unsigned long       CRLNumber;
  char                SignAlg[32];
  char                Issuer[256];
  unsigned char       IssSerNum[64];
  unsigned long       IssSerNumSize;
  char                ThisUpdate[16];
  char                NextUpdate[16];
  int                 entryCount;
  char                CApoint[128];
  unsigned char		    *CRLBody;
  unsigned long		    CRLSize;
} CRL_INF, *PCRL_INF;


#endif
